import java.sql.*;

public class Main
{
  public static void main(String args[])
  {
    if (args.length < 1){
      System.out.println(
        "Wywoanie programu: Main \"zapytanie SQL\"");
      System.exit(0);
    }
    
    Connection conn = DBConnection.getConnection(
      "jdbc:mysql://localhost:3306/test", "test", "test");
    if(conn == null){
      System.out.println("Nie mona nawiza poczenia z baz.");
      System.exit(-1);
    }
    
    try{
      Statement stm = conn.createStatement();
      if(stm.execute(args[0])){
        ResultSet rs = stm.getResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        int colsNo = rsmd.getColumnCount();
        String str = "";
        while(rs.next()){
          for(int i = 1; i <= colsNo; i++){
            str += rs.getString(i);
            str += i < colsNo ? " | " : "";
          }
          str += "\n";
        }
        System.out.print(str);
      }
      else{
        System.out.println("Liczba zmodyfikowanych rekordw: " + 
           stm.getUpdateCount());
      }
    }
    catch(SQLException e){
      System.out.println("Bd przy przetwarzaniu danych: " + e);
    }
    
    try{conn.close();}
    catch(SQLException e){
      System.out.println("Bd przy zamykaniu poczenia: " + e);
    }
  }
}
